/***************************************************************************
 *
 * Copyright (c) 2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef MATRIX_H_
#define MATRIX_H_

#include <iostream>

#include "CalibrationTypes.h"

#define MATRIX_COLUMNS 3
#define MATRIX_ROWS 3

namespace LayerManagerCalibration
{

    class Matrix
    {
    public:
        typedef double Data[MATRIX_ROWS][MATRIX_COLUMNS];
    private:
        Data data;
    public:
        Matrix();
        Matrix(const Data& matrixVal);
        Matrix(const Matrix& other);
        virtual ~Matrix();
        Matrix& operator=(const Matrix& rhs);
        Matrix& operator=(const Data& rhs);
        Matrix operator*(const Matrix& rhs);
        Matrix operator*(const double rhs);
        vector3 operator*(const vector3& rhs);
        bool operator==(const Matrix& rhs);
        void transposeMatrix();
        void adjugateMatrix();
        double calculateDeterminant();
        const Data& getData() const;
        void setData(const Data& matrixData);
    };

    std::ostream& operator<<(std::ostream& os, const Matrix& rhs);
    std::istream& operator>>(std::istream& is, Matrix& rhs);

    inline const Matrix::Data& Matrix::getData() const
    {
        return data;
    }

    inline void Matrix::setData(const Data& matrixData)
    {
        for (int i = 0; i < MATRIX_ROWS; ++i)
        {
            for (int j = 0; j < MATRIX_COLUMNS; ++j)
            {
                this->data[i][j] = matrixData[i][j];
            }
        }
    }

} /* namespace LayerManagerCalibration */
#endif /* MATRIX_H_ */

